# ⚡ Quick Start - Get Your Emails Working in 2 Minutes

## 🎯 Your Email Design is READY!

All the beautiful email templates are already coded. You just need to connect your email account.

---

## 📝 Step 1: Create `.env` File (30 seconds)

In the `server/` folder, create a new file named `.env` (yes, it starts with a dot)

**Copy and paste this:**

```env
SMTP_HOST=mail.taxiagadirairport.com
SMTP_PORT=587
EMAIL_USER=info@taxiagadirairport.com
EMAIL_PASS=PUT_YOUR_PASSWORD_HERE
```

**Change:** `PUT_YOUR_PASSWORD_HERE` to your actual email password

---

## 🔑 Step 2: Get Your Email Password (1 minute)

1. Login to **Namecheap**
2. Go to **cPanel**
3. Find **Email Accounts**
4. Locate **info@taxiagadirairport.com**
5. Copy or reset the password
6. Paste it in the `.env` file

---

## 🚀 Step 3: Start Server (10 seconds)

Open terminal in the `server/` folder:

```bash
node server.js
```

You should see:
```
Server is running on port 5000
Email Configuration:
- Host: mail.taxiagadirairport.com
- Port: 587
- User: info@taxiagadirairport.com
```

---

## ✅ Step 4: Test It! (30 seconds)

1. Open your website
2. Fill the **booking form**
3. Click **Submit**

**You'll receive 2 emails:**
- ✉️ Admin notification (to info@taxiagadirairport.com)
- ✉️ Customer confirmation (to the email you entered)

---

## 🎨 Preview Emails

Want to see the designs first?

Open in your browser:
```
server/email-templates/index.html
```

Shows all 3 email templates with live previews!

---

## ❓ Troubleshooting

### Emails not sending?

**Check #1:** Is `.env` file created?  
→ Look in `server/` folder for `.env`

**Check #2:** Is password correct?  
→ Try resetting it in Namecheap cPanel

**Check #3:** Is server running?  
→ You should see "Server is running..." message

**Check #4:** Check spam folder  
→ Sometimes first email goes to spam

**Check #5:** Try different port  
→ Change `SMTP_PORT=587` to `SMTP_PORT=465`

---

## 📧 What You'll Get

### Customer Confirmation Email (Green)
- ✅ Success badge
- 🎉 Welcome message
- 📋 Booking summary
- 📌 Next steps
- 💬 WhatsApp button

### Admin Alert Email (Blue)
- ⚡ Urgent badge
- 👤 Customer details
- 🚗 Trip information
- ⏰ Action required

### Contact Email (Orange)
- 💬 Message badge
- 📝 Customer message
- 📞 Contact details

---

## 🎯 That's It!

Once you complete these 4 steps, you'll have a **professional automated email system**!

**Need more help?** See `EMAIL_SETUP_GUIDE.md`

---

**Ready?** Create that `.env` file and let's go! 🚀

