# 📧 Email Server - Taxi Agadir Airport

Professional email notification system with beautiful HTML templates for taxi booking and contact forms.

---

## ✨ What's Included

✅ **3 Professional Email Templates** with beautiful designs  
✅ **Automated Email System** - Sends emails on form submission  
✅ **Customer Confirmations** - Instant booking confirmations  
✅ **Admin Notifications** - Get alerted of new bookings  
✅ **Mobile Responsive** - Perfect on all devices  
✅ **Brand Designed** - Your colors and style  

---

## 🚀 Quick Start (2 Minutes!)

**👉 See `QUICK_START.md` for step-by-step setup**

### Super Quick Version:

1. **Create `.env` file** in this folder:
   ```env
   SMTP_HOST=mail.taxiagadirairport.com
   SMTP_PORT=587
   EMAIL_USER=info@taxiagadirairport.com
   EMAIL_PASS=your_password_here
   ```

2. **Run server:**
   ```bash
   node server.js
   ```

3. **Test it** - Submit a booking form on your website

4. **Done!** Check your email 📧

---

## 📚 Full Documentation

- **`QUICK_START.md`** - Get running in 2 minutes ⚡
- **`EMAIL_SETUP_GUIDE.md`** - Complete setup instructions 📖
- **`EMAIL_SUMMARY.md`** - Overview of all features 📊
- **`setup-email.txt`** - Simple text guide 📝
- **`email-templates/`** - Preview the beautiful designs 🎨

---

## 🎨 Preview Email Designs

**Open this in your browser:**
```
email-templates/index.html
```

Shows all 3 email templates with live previews!

Individual previews:
- `customer-confirmation-preview.html` - Customer gets this (Green theme)
- `booking-email-preview.html` - You get this (Blue theme)
- `contact-email-preview.html` - Contact messages (Orange theme)

---

## 📧 The 3 Email Templates

### 1. **Customer Confirmation** (Green ✅)
**Sent to:** Customer's email  
**Contains:**
- Welcome message with customer's name
- Complete booking summary
- Next steps guide
- WhatsApp button
- All contact info

### 2. **Admin Booking Alert** (Blue 🚕)
**Sent to:** info@taxiagadirairport.com  
**Contains:**
- URGENT priority badge
- Customer details
- Trip information
- Action required alert

### 3. **Contact Message** (Orange 💬)
**Sent to:** info@taxiagadirairport.com  
**Contains:**
- Customer contact info
- Their message
- Quick response reminder

---

## 🔧 Installation

### Install Dependencies
```bash
cd server
npm install
```

### Configure Email (.env file)

#### For Namecheap Hosting:
```env
SMTP_HOST=mail.taxiagadirairport.com
SMTP_PORT=587
EMAIL_USER=info@taxiagadirairport.com
EMAIL_PASS=your_email_password
```

#### Alternative: Using Gmail
```env
SMTP_HOST=smtp.gmail.com
SMTP_PORT=587
EMAIL_USER=your@gmail.com
EMAIL_PASS=your_app_password
```

---

## 🚀 Running the Server

### Development:
```bash
node server.js
```

### Production with PM2:
```bash
npm install -g pm2
pm2 start server.js --name "taxi-email-server"
pm2 save
pm2 startup
```

Server runs on: `http://localhost:5000`

---

## 📡 API Endpoints

### POST /api/booking
Handles booking form submissions  
**Sends:** Admin alert + Customer confirmation

### POST /api/contact
Handles contact form submissions  
**Sends:** Admin notification

### GET /api/health
Check if server is running  
**Returns:** `{ status: 'OK' }`

---

## ✅ Testing

### Test Booking Email:
```bash
curl -X POST http://localhost:5000/api/booking \
  -H "Content-Type: application/json" \
  -d '{
    "from": "Aéroport Agadir",
    "to": "Hôtel à Agadir",
    "arrival-date": "2025-01-15T10:00",
    "fullname": "Jean Dupont",
    "email": "jean@example.com",
    "phone": "+33612345678",
    "address": "Hotel Paradise",
    "passengers": "2",
    "trip-type": "round-trip"
  }'
```

### Or Simply:
1. Go to your website
2. Fill the booking form
3. Submit
4. Check emails!

---

## 🎯 What Happens When Form is Submitted

```
Customer submits booking form
        ↓
Server receives data
        ↓
    ┌───┴───┐
    │       │
    ↓       ↓
Admin    Customer
Email   Confirmation
(Blue)    (Green)
```

**Both emails sent automatically!**

---

## 📦 Dependencies

```json
{
  "express": "^4.18.2",
  "cors": "^2.8.5",
  "nodemailer": "^6.9.7",
  "dotenv": "^16.3.1"
}
```

---

## 🔐 Security

✅ `.env` file in `.gitignore` (never committed)  
✅ TLS encryption on port 587  
✅ No passwords in code  
✅ Environment variables only  
✅ CORS configured  

---

## ❓ Troubleshooting

### Emails not sending?

**1. Check `.env` file exists**
   - Must be in `server/` folder
   - Named exactly `.env`

**2. Verify email credentials**
   - Get password from Namecheap cPanel
   - Or reset it

**3. Try different port**
   ```env
   SMTP_PORT=465  # instead of 587
   ```

**4. Check server logs**
   - Look for error messages
   - Verify "Email sent successfully"

**5. Check spam folder**
   - First emails might go to spam

### Still not working?

See `EMAIL_SETUP_GUIDE.md` for detailed troubleshooting

---

## 🌐 Production Deployment

### On Your Hosting:

1. **Upload server folder**
2. **Install dependencies:** `npm install`
3. **Create `.env` file** with your credentials
4. **Start server:** `node server.js` or use PM2
5. **Update frontend** to point to your server URL

### Environment Variables:

Instead of `.env` file, set in hosting panel:
- `SMTP_HOST`
- `SMTP_PORT`
- `EMAIL_USER`
- `EMAIL_PASS`

---

## 📱 CORS Configuration

Server allows requests from:
- Your website domain
- localhost (for development)

Update in `server.js` if needed.

---

## 🎨 Customizing Email Templates

Email HTML is in `server.js`:

- **Customer Confirmation:** Lines ~210-362
- **Admin Booking:** Lines ~59-203
- **Contact Form:** Lines ~395-500+

Modify colors, text, layout as needed.

---

## 📊 Email Features

✅ Responsive design (mobile-friendly)  
✅ Professional gradient headers  
✅ Clickable phone & email links  
✅ WhatsApp integration  
✅ Emoji icons for visual appeal  
✅ Complete branding  
✅ Timestamp display  
✅ Action alerts  
✅ Clean typography  
✅ Shadow effects  

---

## 📞 Server Logs

When running, you'll see:

```
Server is running on port 5000
Email Configuration:
- Host: mail.taxiagadirairport.com
- Port: 587
- User: info@taxiagadirairport.com

Attempting to send booking email to admin...
Booking email sent to admin successfully!
Attempting to send confirmation email to customer...
Confirmation email sent to customer successfully!
```

---

## 🎓 Need Help?

1. **Quick Start:** See `QUICK_START.md`
2. **Full Guide:** See `EMAIL_SETUP_GUIDE.md`
3. **Overview:** See `EMAIL_SUMMARY.md`
4. **Preview Designs:** Open `email-templates/index.html`

---

## ✨ Features Summary

| Feature | Status |
|---------|--------|
| Customer Confirmation | ✅ Ready |
| Admin Notifications | ✅ Ready |
| Contact Form Emails | ✅ Ready |
| Mobile Responsive | ✅ Yes |
| WhatsApp Integration | ✅ Yes |
| Branded Design | ✅ Yes |
| Production Ready | ✅ Yes |

---

## 📄 License

MIT - Taxi Agadir Airport

---

**Created:** October 29, 2025  
**Status:** ✅ Production Ready  
**Version:** 2.0 - Enhanced Email Design with Customer Confirmations

---

**Ready to start?** See `QUICK_START.md` and you'll have emails working in 2 minutes! 🚀
