# SMTP Port Configuration Guide

Your Namecheap server supports multiple ports. The configuration will automatically adjust based on the port you choose.

## Current Configuration
- **Server:** premium259.web-hosting.com
- **Port:** 465 (SSL)
- **Email:** info@taxiagadirairport.com

## Available Ports

### Port 465 (SSL) - RECOMMENDED ✅
```env
SMTP_HOST=premium259.web-hosting.com
SMTP_PORT=465
```
- Uses SSL encryption
- Most reliable
- Currently configured

### Port 587 (TLS)
```env
SMTP_HOST=premium259.web-hosting.com
SMTP_PORT=587
```
- Uses TLS encryption
- Alternative if 465 doesn't work

### Port 25 (TLS)
```env
SMTP_HOST=premium259.web-hosting.com
SMTP_PORT=25
```
- Uses TLS encryption
- May be blocked by some ISPs
- Use as last resort

## How to Change Ports

1. Open `server/.env`
2. Change the `SMTP_PORT` value
3. Restart the server (`npm run dev`)

The server will automatically use the correct encryption (SSL or TLS) based on the port.

## Testing

After changing the port, test by:
1. Starting the server: `npm run dev`
2. Submitting a form on your website
3. Checking your email inbox

If emails don't arrive, try the next port option.
