# 📦 What to Upload to Namecheap Backend Server

## ✅ Required Files (Upload These)

Upload ONLY these PHP files to your Namecheap server:

### Core PHP Files

1. **booking.php** ✅
   - Handles booking form submissions
   - Size: ~23 KB

2. **contact.php** ✅
   - Handles contact form submissions
   - Size: ~10 KB

3. **health.php** ✅
   - Health check endpoint
   - Size: ~213 bytes

4. **config.php** ✅
   - Configuration loader
   - Size: ~1 KB

5. **test.php** ✅ (optional, for testing only)
   - Testing script
   - Size: ~3 KB

6. **.htaccess** ✅
   - Apache configuration
   - Size: ~1 KB

### Environment File

7. **.env** ✅ (create this first!)
   - Environment variables
   - Contains email credentials
   - Keep this SECURE!

## 📁 Where to Upload on Namecheap

### Option 1: If you have a separate API folder

```
public_html/
└── api/
    ├── booking.php
    ├── contact.php
    ├── health.php
    ├── config.php
    ├── test.php
    ├── .htaccess
    └── .env
```

### Option 2: If you upload to root server directory

```
server/  (or create this folder)
├── booking.php
├── contact.php
├── health.php
├── config.php
├── test.php
├── .htaccess
└── .env
```

### Option 3: Upload directly to server folder (recommended)

```
public_html/
├── index.html (your React app)
├── assets/ (your React build)
└── server/ (or api/)
    ├── booking.php
    ├── contact.php
    ├── health.php
    ├── config.php
    ├── test.php
    ├── .htaccess
    └── .env
```

## 🚫 DO NOT Upload These Files

These files are NOT needed on Namecheap:

❌ **server.js** (Node.js file - not needed)  
❌ **package.json** (not needed)  
❌ **package-lock.json** (not needed)  
❌ **node_modules/** (not needed)  
❌ **railway.json** (not needed)  
❌ **README.md** (not needed)  
❌ **PHP_DEPLOYMENT_GUIDE.md** (documentation only)  
❌ **README_PHP.md** (documentation only)  
❌ **CONVERSION_SUMMARY.md** (documentation only)  
❌ **email-templates/** (folders - templates are embedded in PHP)  
❌ All other .md files (documentation only)  

## 📝 Step-by-Step Upload Instructions

### Step 1: Create .env File Locally First

Before uploading, create a `.env` file with your email settings:

**Create this file:** `server/.env`

```env
# Email Configuration
SMTP_HOST=mail.taxiagadirairport.com
SMTP_PORT=587
EMAIL_USER=info@taxiagadirairport.com
EMAIL_PASS=your_actual_password_here

# Server Configuration (optional)
PORT=5000
NODE_ENV=production
```

**⚠️ IMPORTANT:** Replace `your_actual_password_here` with your real email password!

### Step 2: Upload Files via FTP or File Manager

#### Method A: Using cPanel File Manager

1. Login to Namecheap cPanel
2. Open "File Manager"
3. Navigate to `public_html`
4. Create folder `api` or `server` (if not exists)
5. Upload these 6 files:
   - booking.php
   - contact.php
   - health.php
   - config.php
   - test.php
   - .htaccess
   - .env (upload this last!)

#### Method B: Using FTP (FileZilla, etc.)

1. Connect to your Namecheap FTP
2. Navigate to `public_html/api/` or `public_html/server/`
3. Upload the 6 files above

### Step 3: Set File Permissions

After uploading, set these permissions in cPanel File Manager:

- **booking.php**: 644
- **contact.php**: 644
- **health.php**: 644
- **config.php**: 644
- **test.php**: 644
- **.htaccess**: 644
- **.env**: 600 (restricted for security)

How to set permissions in cPanel:
1. Right-click on file
2. Select "Change Permissions"
3. Enter the number (644 or 600)
4. Click "Change Permissions"

### Step 4: Test Your Upload

Visit these URLs in your browser:

```
https://taxiagadirairport.com/api/test.php
https://taxiagadirairport.com/api/health
```

If you see JSON responses, your upload worked! ✅

## 🔧 After Upload: Update Frontend

Once files are uploaded, you need to update your React app to use the PHP server instead of Railway.

### Update BookingForm.tsx

Change this line:
```javascript
// OLD (Railway)
const apiUrl = 'https://taxiagadir-production.up.railway.app/api/booking';

// NEW (Your domain)
const apiUrl = '/api/booking';
// OR
const apiUrl = 'https://taxiagadirairport.com/api/booking';
```

### Update Contact.tsx

Same change:
```javascript
// OLD
const apiUrl = 'https://taxiagadir-production.up.railway.app/api/contact';

// NEW
const apiUrl = '/api/contact';
// OR
const apiUrl = 'https://taxiagadirairport.com/api/contact';
```

## 📋 Quick Upload Checklist

- [ ] Created `.env` file with real credentials
- [ ] Uploaded booking.php
- [ ] Uploaded contact.php
- [ ] Uploaded health.php
- [ ] Uploaded config.php
- [ ] Uploaded test.php
- [ ] Uploaded .htaccess
- [ ] Uploaded .env
- [ ] Set all PHP files to 644 permissions
- [ ] Set .env to 600 permissions
- [ ] Tested test.php endpoint
- [ ] Tested health endpoint
- [ ] Updated frontend API URLs
- [ ] Tested booking form
- [ ] Tested contact form

## 🚨 Troubleshooting

### "404 Not Found" Error

Check:
- File names are exact (case-sensitive)
- Files are in correct directory
- .htaccess is uploaded
- Apache mod_rewrite is enabled

### "500 Internal Server Error"

Check:
- File permissions are 644
- .htaccess syntax is correct
- PHP version is 7.4 or higher
- Error logs in cPanel

### Emails Not Sending

Check:
- .env file has correct credentials
- PHP mail() function is enabled
- Contact hosting support for SMTP settings

## 📞 Need Help?

1. Check test.php for diagnostics
2. Review PHP_DEPLOYMENT_GUIDE.md
3. Check cPanel error logs
4. Contact Namecheap support

---

## 📁 Complete File List Summary

**Upload These 7 Files:**

```
1. booking.php       (~23 KB)
2. contact.php       (~10 KB)
3. health.php        (~213 bytes)
4. config.php        (~1 KB)
5. test.php          (~3 KB)
6. .htaccess         (~1 KB)
7. .env              (~500 bytes) ⚠️ Create this!
```

**Total:** ~38 KB of PHP files

That's it! Your entire backend is just 7 small files. 🎉

